# 🏝️ Esat Can Travel - Chrome Extension v2.0

Endonezya turları için hızlı erişim extension'ı.

## ✨ Özellikler

### 🔐 Kullanıcı Girişi
- Site hesabınla giriş yap
- Güvenli oturum yönetimi

### ⭐ Favoriler
- Beğendiğin turları kaydet
- Tek tıkla tur detayına git
- Offline erişim

### 📋 Rezervasyonlarım
- Tüm rezervasyonlarını görüntüle
- Durum takibi (Beklemede, Onaylandı, vs.)
- Rezervasyon detayları

### 🗺️ Turlar
- Son eklenen turlar
- Basit liste görünümü
- Hızlı tur erişimi

### 📸 Fotoğraf Hizmetleri
- BAŞLANGIÇ Paket - $250
- PREMİUM Paket - $500
- LÜKS Paket - $1000

### 💱 IDR → TRY Kur Çevirici
- Admin tarafından güncellenen güncel kurlar
- Anlık hesaplama
- Manuel güncelleme

## 📦 Kurulum

### Gereksinimler
- Google Chrome (veya Chromium tabanlı tarayıcı)
- Esat Can Travel hesabı

### Adımlar

1. **Extension Klasörünü Hazırla**
   - Bu klasörü bilgisayarına kaydet
   - Tam yol: `/Users/esat/Desktop/public_html/chrome-extension/`

2. **Chrome Extensions Sayfasını Aç**
   - Adres çubuğuna yaz: `chrome://extensions/`

3. **Geliştirici Modunu Aktif Et**
   - Sağ üst köşede "Geliştirici modu" düğmesini aç

4. **Extension'ı Yükle**
   - "Paketlenmemiş uzantı yükle" butonuna tıkla
   - `chrome-extension/` klasörünü seç

5. **Sabitle**
   - Extension ikonuna sağ tık → "Pin"

## 🚀 Kullanım

### İlk Giriş
1. Extension ikonuna tıkla
2. Kullanıcı adı ve şifreni gir
3. "Giriş Yap" butonuna tıkla

### Favorilere Ekleme
1. Sitede bir tura git
2. Extension açık olduğunda favorilere ekle
3. Extension'da Favoriler sekmesinden eriş

### Rezervasyonları Görüntüleme
1. Extension'ı aç
2. "Rezervasyonlar" sekmesine git
3. Tüm rezervasyonlarını gör

### Kur Çevirme
1. "Kur" sekmesine git
2. IDR miktarını gir
3. Otomatik TRY karşılığını gör
4. "Kurları Güncelle" ile yeni kurları çek

## 🔧 API Endpoints

Extension şu API'leri kullanır:

- `POST /api/extension-login.php` - Giriş
- `GET /api/get-user-reservations.php?user_id=X` - Rezervasyonlar
- `GET /api/get-tours.php` - Turlar
- `GET /api/get-exchange-rates.php` - Döviz kurları

## 📱 Ekran Görüntüleri

**Login Ekranı:**
- Kullanıcı adı ve şifre girişi
- "Siteye Git" linki

**Ana Ekran:**
- 5 Sekme: Favoriler, Rezervasyonlar, Turlar, Fotoğraf, Kur
- Kullanıcı bilgisi ve çıkış butonu

**Favoriler:**
- Liste görünümü
- Tur başlığı, lokasyon, fiyat

**Rezervasyonlar:**
- Durum badge'leri
- Tarih ve iletişim bilgileri

**Kur Çevirici:**
- Büyük kur göstergesi
- IDR → TRY hesaplama
- Son güncelleme tarihi

## ⚙️ Ayarlar

Extension verilerini temizlemek için:
1. Chrome'da `chrome://extensions/`
2. Esat Can Travel → "Detaylar"
3. "Uzantı verilerini temizle"

## 🐛 Sorun Giderme

### Giriş yapamıyorum
- Site hesabının aktif olduğundan emin ol
- Kullanıcı adı ve şifrenin doğru olduğunu kontrol et
- Internet bağlantını kontrol et

### Rezervasyonlar görünmüyor
- Giriş yaptığın hesapla rezervasyon yaptığından emin ol
- Email adresin rezervasyondaki ile aynı mı?

### Kurlar güncellenmiyor
- "Kurları Güncelle" butonuna tıkla
- Adminlerin güncel kur girdiğinden emin ol

### Extension yüklenmiyor
- İkon dosyalarının `icons/` klasöründe olduğunu kontrol et
- `manifest.json` dosyasının var olduğunu kontrol et

## 🔒 Güvenlik

- Şifreler şifrelenerek saklanır
- Session token kullanılır
- HTTPS üzerinden iletişim

## 📝 Versiyon Geçmişi

### v2.0.0 (2025-10-06)
- Tamamen yeniden tasarlandı
- Kullanıcı girişi eklendi
- Rezervasyonlar eklendi
- Fotoğraf hizmetleri eklendi
- IDR-TRY kur çevirici
- Çeviri özelliği kaldırıldı
- Basitleştirilmiş arayüz

### v1.0.0 (2025-10-06)
- İlk versiyon
- Favoriler, para birimi, çeviri, araçlar

## 📧 Destek

Sorun veya önerilerin için:
- 📧 Email: info@esatcantravel.net
- 💬 WhatsApp: +62 813 3757 1166
- 🌐 Website: esatcantravel.net

## 📄 Lisans

© 2025 Esat Can Travel. Tüm hakları saklıdır.
